<?php
/**
 * Main dashboard view for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current tab
$current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';

// Get current subtab (for tabs with subtabs like Backlinks)
$current_subtab = isset($_GET['subtab']) ? sanitize_text_field($_GET['subtab']) : '';
?>

<!-- CRITICAL: Inline drag prevention - Safari requires special handling -->
<script>
if (!window._sfDragPreventionLoaded) {
    window._sfDragPreventionLoaded = true;
    (function(){
        // Check if target is inside our upload zone
        var isUploadZone = function(el) {
            while (el) {
                if (el.classList && (el.classList.contains('sf-upload-box') || el.classList.contains('sf-upload-zone'))) {
                    return true;
                }
                el = el.parentElement;
            }
            return false;
        };

        var opts = { capture: true, passive: false };

        // For dragover - always preventDefault to allow drop, but don't stop propagation
        var handleDragOver = function(e) {
            e.preventDefault();
            if (e.dataTransfer) {
                // Set copy effect for upload zones, none for elsewhere
                e.dataTransfer.dropEffect = isUploadZone(e.target) ? 'copy' : 'none';
            }
        };

        // For drop - only preventDefault if NOT in upload zone (let upload zone handle it)
        var handleDrop = function(e) {
            if (!isUploadZone(e.target)) {
                e.preventDefault();
                e.stopPropagation();
                if (e.dataTransfer) {
                    e.dataTransfer.dropEffect = 'none';
                }
                return false;
            }
            // If in upload zone, just preventDefault but let it bubble to our handler
            e.preventDefault();
        };

        document.addEventListener('dragover', handleDragOver, opts);
        document.addEventListener('drop', handleDrop, opts);
        window.addEventListener('dragover', handleDragOver, opts);
        window.addEventListener('drop', handleDrop, opts);

        if (document.documentElement) {
            document.documentElement.addEventListener('dragover', handleDragOver, opts);
            document.documentElement.addEventListener('drop', handleDrop, opts);
        }
    })();
}
</script>

<div class="wrap sf-wrap">
    <?php
    // Include header with tabs
    include SF_PLUGIN_DIR . 'admin/views/partials/header.php';
    ?>

    <div class="sf-content">
        <?php
        // Route to appropriate view based on tab
        switch ($current_tab) {
            case 'broken-links':
                if (file_exists(SF_PLUGIN_DIR . 'modules/broken-links/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/broken-links/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'redirect-chains':
                if (file_exists(SF_PLUGIN_DIR . 'modules/redirect-chains/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/redirect-chains/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'backlinks':
                // Handle Backlinks subtabs (reclaim or evaluator)
                $backlinks_subtab = !empty($current_subtab) ? $current_subtab : 'reclaim';

                if ($backlinks_subtab === 'evaluator') {
                    // Backlink Evaluator
                    if (file_exists(SF_PLUGIN_DIR . 'modules/backlink-evaluator/views/tab-content.php')) {
                        include SF_PLUGIN_DIR . 'modules/backlink-evaluator/views/tab-content.php';
                    } else {
                        include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                    }
                } else {
                    // Backlink Reclaim (default)
                    if (file_exists(SF_PLUGIN_DIR . 'modules/backlink-reclaim/views/tab-content.php')) {
                        include SF_PLUGIN_DIR . 'modules/backlink-reclaim/views/tab-content.php';
                    } else {
                        include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                    }
                }
                break;

            case 'image-alt-text':
                if (file_exists(SF_PLUGIN_DIR . 'modules/image-alt-text/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/image-alt-text/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'meta-description':
                if (file_exists(SF_PLUGIN_DIR . 'modules/meta-description/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/meta-description/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'page-title':
                if (file_exists(SF_PLUGIN_DIR . 'modules/page-title/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/page-title/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'internal-link-builder':
                if (file_exists(SF_PLUGIN_DIR . 'modules/internal-link-builder/views/tab-content.php')) {
                    include SF_PLUGIN_DIR . 'modules/internal-link-builder/views/tab-content.php';
                } else {
                    include SF_PLUGIN_DIR . 'admin/views/partials/module-placeholder.php';
                }
                break;

            case 'settings':
                include SF_PLUGIN_DIR . 'admin/views/settings.php';
                break;

            case 'dashboard':
            default:
                // Dashboard home view
                ?>
                <!-- Intro Banner -->
                <div class="sf-dashboard-intro">
                    <h2><?php esc_html_e('Finding SEO problems is easy. Fixing them sucks.', 'screaming-fixes'); ?></h2>
                    <p><?php esc_html_e('This plugin actually fixes them - in bulk. Upload your Screaming Frog CSV, review the fixes, and apply them all at once.', 'screaming-fixes'); ?></p>
                </div>

                <!-- Welcome Message (dismissible, one-time) -->
                <?php include SF_PLUGIN_DIR . 'admin/views/partials/welcome-message.php'; ?>

                <!-- Quick Upload -->
                <div class="sf-quick-upload">
                    <h2>
                        <span>&#128228;</span>
                        <?php esc_html_e('Quick Upload', 'screaming-fixes'); ?>
                    </h2>
                    <p><?php esc_html_e("Drop any Screaming Frog CSV here - we'll auto-detect the type", 'screaming-fixes'); ?></p>

                    <?php
                    $args = [
                        'auto_detect' => true,
                        'title' => __('Drop your CSV file', 'screaming-fixes'),
                        'description' => __('Drag & drop CSV here or click to browse', 'screaming-fixes'),
                        'max_rows' => 5000,
                    ];
                    include SF_PLUGIN_DIR . 'admin/views/partials/upload-box.php';
                    ?>
                </div>

                <!-- Stats Cards -->
                <?php include SF_PLUGIN_DIR . 'admin/views/partials/stats-cards.php'; ?>

                <?php
                break;
        }
        ?>
    </div>

    <?php
    // Include footer
    include SF_PLUGIN_DIR . 'admin/views/partials/footer.php';

    // Include revisions modal
    include SF_PLUGIN_DIR . 'admin/views/partials/revisions-modal.php';
    ?>
</div>
