<?php
/**
 * Footer partial with lead gen CTAs for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get subscribed email if exists
$subscribed_email = get_option('sf_email_subscribed', '');
$is_subscribed = !empty($subscribed_email);
?>

<div class="sf-footer">
    <div class="sf-footer-ctas">

        <!-- Email Capture -->
        <div class="sf-footer-cta sf-email-capture">
            <div class="sf-cta-icon">&#128231;</div>
            <div class="sf-cta-content">
                <?php if ($is_subscribed) : ?>
                    <span class="sf-cta-text sf-subscribed">
                        <span class="sf-check-icon">&#10003;</span>
                        <?php esc_html_e('Subscribed to updates', 'screaming-fixes'); ?>
                    </span>
                <?php else : ?>
                    <span class="sf-cta-text"><?php esc_html_e('Get SEO tips & updates', 'screaming-fixes'); ?></span>
                    <div class="sf-email-form">
                        <input
                            type="email"
                            id="sf-footer-email"
                            class="sf-input sf-email-input"
                            placeholder="your@email.com"
                            aria-label="<?php esc_attr_e('Email address', 'screaming-fixes'); ?>"
                        />
                        <button type="button" id="sf-footer-subscribe" class="sf-button sf-button-primary sf-button-small">
                            <?php esc_html_e('Subscribe', 'screaming-fixes'); ?>
                        </button>
                    </div>
                    <div id="sf-footer-subscribe-status" class="sf-footer-status" style="display: none;"></div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Divider -->
        <div class="sf-footer-divider"></div>

        <!-- Feedback/Help CTA -->
        <div class="sf-footer-cta sf-feedback-cta">
            <div class="sf-cta-icon">&#128161;</div>
            <div class="sf-cta-content">
                <span class="sf-cta-title"><?php esc_html_e('Got feedback? Need help?', 'screaming-fixes'); ?></span>
                <span class="sf-cta-description"><?php esc_html_e('This plugin is actively being improved! Email me for feature requests, bug reports, or if you need help fixing your site.', 'screaming-fixes'); ?></span>
                <a href="mailto:brett.lindenberg@gmail.com" class="sf-footer-email-link">
                    &#128231; brett.lindenberg@gmail.com
                </a>
            </div>
        </div>

    </div>

    <!-- Credits -->
    <div class="sf-footer-credits">
        <p>
            <?php
            printf(
                esc_html__('Screaming Fixes v%s by %s', 'screaming-fixes'),
                esc_html(SF_VERSION),
                '<a href="https://screamingfixes.com" target="_blank" rel="noopener">Brett Lindenberg</a>'
            );
            ?>
            &nbsp;&bull;&nbsp;
            <a href="https://wordpress.org/support/plugin/screaming-fixes/" target="_blank" rel="noopener">
                <?php esc_html_e('Support', 'screaming-fixes'); ?>
            </a>
            &nbsp;&bull;&nbsp;
            <a href="https://wordpress.org/support/plugin/screaming-fixes/reviews/#new-post" target="_blank" rel="noopener">
                <?php esc_html_e('Leave a Review', 'screaming-fixes'); ?>
            </a>
        </p>
    </div>
</div>
