<?php
/**
 * Header partial with tab navigation for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current tab from URL
$current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';

// Get current subtab (for tabs with subtabs like Backlinks)
$current_subtab = isset($_GET['subtab']) ? sanitize_text_field($_GET['subtab']) : '';

// Define tabs
$tabs = [
    'dashboard' => [
        'label' => __('Dashboard', 'screaming-fixes'),
        'icon' => 'dashicons-dashboard',
        'show_in_nav' => false, // Dashboard is home, not shown as tab
    ],
    'broken-links' => [
        'label' => __('Broken Links', 'screaming-fixes'),
        'icon' => 'dashicons-admin-links',
        'emoji' => '&#128279;', // 🔗
    ],
    'redirect-chains' => [
        'label' => __('Redirect Chains', 'screaming-fixes'),
        'icon' => 'dashicons-randomize',
        'emoji' => '&#128260;', // 🔄
    ],
    'backlinks' => [
        'label' => __('Backlinks', 'screaming-fixes'),
        'icon' => 'dashicons-undo',
        'emoji' => '&#128281;', // 🔙
        'has_subtabs' => true,
        'subtabs' => [
            'reclaim' => [
                'label' => __('Reclaim', 'screaming-fixes'),
                'description' => __('Find and fix broken backlinks', 'screaming-fixes'),
            ],
            'evaluator' => [
                'label' => __('Evaluator', 'screaming-fixes'),
                'description' => __('Analyze your backlink profile', 'screaming-fixes'),
            ],
        ],
        'default_subtab' => 'reclaim',
    ],
    'image-alt-text' => [
        'label' => __('Alt Text', 'screaming-fixes'),
        'icon' => 'dashicons-format-image',
        'emoji' => '&#128444;', // 🖼️
    ],
    'meta-description' => [
        'label' => __('Meta Desc', 'screaming-fixes'),
        'icon' => 'dashicons-editor-alignleft',
        'emoji' => '&#128196;', // 📄
    ],
    'page-title' => [
        'label' => __('Page Title', 'screaming-fixes'),
        'icon' => 'dashicons-heading',
        'emoji' => '&#127991;', // 🏷️
    ],
    'internal-link-builder' => [
        'label' => __('Internal Links', 'screaming-fixes'),
        'icon' => 'dashicons-admin-links',
        'emoji' => '&#128279;', // 🔗
    ],
    'settings' => [
        'label' => __('Settings', 'screaming-fixes'),
        'icon' => 'dashicons-admin-generic',
        'emoji' => '&#9881;', // ⚙️
    ],
];

// Filter tabs
$tabs = apply_filters('sf_admin_tabs', $tabs);

// Base URL
$base_url = admin_url('admin.php?page=screaming-fixes');

// Check if current tab has subtabs and set default if needed
$has_subtabs = isset($tabs[$current_tab]['has_subtabs']) && $tabs[$current_tab]['has_subtabs'];
if ($has_subtabs && empty($current_subtab)) {
    $current_subtab = $tabs[$current_tab]['default_subtab'] ?? array_key_first($tabs[$current_tab]['subtabs']);
}
?>

<div class="sf-header">
    <div class="sf-header-top">
        <a href="<?php echo esc_url($base_url); ?>" class="sf-logo-wrapper">
            <span class="sf-logo-icon">&#128295;</span>
            <span class="sf-logo-text"><?php esc_html_e('Screaming Fixes', 'screaming-fixes'); ?></span>
        </a>
        <?php if ($current_tab !== 'dashboard') : ?>
        <a href="<?php echo esc_url($base_url); ?>" class="sf-back-to-dashboard">
            <span class="dashicons dashicons-arrow-left-alt"></span>
            <?php esc_html_e('Dashboard', 'screaming-fixes'); ?>
        </a>
        <?php endif; ?>
    </div>

    <nav class="sf-tabs" role="navigation" aria-label="<?php esc_attr_e('Main navigation', 'screaming-fixes'); ?>">
        <ul class="sf-tab-list">
            <?php foreach ($tabs as $tab_id => $tab) :
                // Skip dashboard in tab nav (it's the home)
                if (isset($tab['show_in_nav']) && $tab['show_in_nav'] === false) {
                    continue;
                }

                $is_active = ($current_tab === $tab_id);
                $tab_url = add_query_arg('tab', $tab_id, $base_url);
            ?>
            <li class="sf-tab-item">
                <a
                    href="<?php echo esc_url($tab_url); ?>"
                    class="sf-tab-link <?php echo $is_active ? 'sf-tab-active' : ''; ?>"
                    <?php echo $is_active ? 'aria-current="page"' : ''; ?>
                >
                    <?php if (isset($tab['emoji'])) : ?>
                        <span class="sf-tab-emoji"><?php echo $tab['emoji']; ?></span>
                    <?php else : ?>
                        <span class="dashicons <?php echo esc_attr($tab['icon']); ?>"></span>
                    <?php endif; ?>
                    <span class="sf-tab-label"><?php echo esc_html($tab['label']); ?></span>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
    </nav>

    <?php if ($has_subtabs && isset($tabs[$current_tab]['subtabs'])) : ?>
    <nav class="sf-subtabs" role="navigation" aria-label="<?php esc_attr_e('Section navigation', 'screaming-fixes'); ?>">
        <ul class="sf-subtab-list">
            <?php foreach ($tabs[$current_tab]['subtabs'] as $subtab_id => $subtab) :
                $is_subtab_active = ($current_subtab === $subtab_id);
                $subtab_url = add_query_arg(['tab' => $current_tab, 'subtab' => $subtab_id], $base_url);
            ?>
            <li class="sf-subtab-item">
                <a
                    href="<?php echo esc_url($subtab_url); ?>"
                    class="sf-subtab-link <?php echo $is_subtab_active ? 'sf-subtab-active' : ''; ?>"
                    <?php echo $is_subtab_active ? 'aria-current="page"' : ''; ?>
                    title="<?php echo esc_attr($subtab['description'] ?? ''); ?>"
                >
                    <span class="sf-subtab-label"><?php echo esc_html($subtab['label']); ?></span>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<?php
// Show any notices
if (isset($_GET['message'])) {
    $message = sanitize_text_field($_GET['message']);
    $type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : 'success';
    ?>
    <div class="sf-notice sf-notice-<?php echo esc_attr($type); ?>" role="alert">
        <p><?php echo esc_html($message); ?></p>
        <button type="button" class="sf-notice-dismiss" aria-label="<?php esc_attr_e('Dismiss', 'screaming-fixes'); ?>">
            <span class="dashicons dashicons-dismiss"></span>
        </button>
    </div>
    <?php
}
?>
