<?php
/**
 * Placeholder view for modules not yet built
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current tab for context
$current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : '';

// Module info
$modules = [
    'broken-links' => [
        'title' => __('Broken Links', 'screaming-fixes'),
        'icon' => '&#128279;',
        'description' => __('Find and fix broken internal links automatically.', 'screaming-fixes'),
    ],
    'redirect-chains' => [
        'title' => __('Redirect Chains', 'screaming-fixes'),
        'icon' => '&#128260;',
        'description' => __('Detect and resolve redirect chains that hurt SEO.', 'screaming-fixes'),
    ],
    'backlinks' => [
        'title' => __('Backlink Reclaim', 'screaming-fixes'),
        'icon' => '&#128281;',
        'description' => __('Reclaim lost backlinks and improve domain authority.', 'screaming-fixes'),
    ],
    'alt-text' => [
        'title' => __('Image Alt Text', 'screaming-fixes'),
        'icon' => '&#128444;',
        'description' => __('Add missing alt text to images for better SEO and accessibility.', 'screaming-fixes'),
    ],
];

$module = isset($modules[$current_tab]) ? $modules[$current_tab] : [
    'title' => __('Module', 'screaming-fixes'),
    'icon' => '&#128295;',
    'description' => '',
];
?>

<div class="sf-module-placeholder">
    <div class="sf-placeholder-content">
        <div class="sf-placeholder-icon">
            <?php echo $module['icon']; ?>
        </div>

        <h2 class="sf-placeholder-title">
            <?php echo esc_html($module['title']); ?>
        </h2>

        <p class="sf-placeholder-description">
            <?php echo esc_html($module['description']); ?>
        </p>

        <div class="sf-placeholder-status">
            <span class="sf-status-badge sf-status-coming-soon">
                <?php esc_html_e('Coming Soon', 'screaming-fixes'); ?>
            </span>
        </div>

        <p class="sf-placeholder-note">
            <?php esc_html_e('This module is under development. Check back soon or subscribe to get notified when it launches.', 'screaming-fixes'); ?>
        </p>

        <a href="<?php echo esc_url(admin_url('admin.php?page=screaming-fixes')); ?>" class="sf-button sf-button-secondary">
            <span class="dashicons dashicons-arrow-left-alt"></span>
            <?php esc_html_e('Back to Dashboard', 'screaming-fixes'); ?>
        </a>
    </div>
</div>

<style>
.sf-module-placeholder {
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 400px;
    background: var(--sf-gray-50, #f9fafb);
    border: 2px dashed var(--sf-gray-300, #d1d5db);
    border-radius: 12px;
    margin: 20px 0;
}

.sf-placeholder-content {
    text-align: center;
    max-width: 400px;
    padding: 40px 20px;
}

.sf-placeholder-icon {
    font-size: 64px;
    line-height: 1;
    margin-bottom: 16px;
    opacity: 0.6;
}

.sf-placeholder-title {
    font-size: 24px;
    font-weight: 600;
    color: var(--sf-gray-800, #1f2937);
    margin: 0 0 8px 0;
}

.sf-placeholder-description {
    font-size: 15px;
    color: var(--sf-gray-500, #6b7280);
    margin: 0 0 20px 0;
}

.sf-placeholder-status {
    margin-bottom: 20px;
}

.sf-status-badge {
    display: inline-block;
    padding: 6px 14px;
    font-size: 13px;
    font-weight: 500;
    border-radius: 20px;
}

.sf-status-coming-soon {
    background: var(--sf-amber-bg, #fffbeb);
    color: var(--sf-amber, #f59e0b);
    border: 1px solid var(--sf-amber, #f59e0b);
}

.sf-placeholder-note {
    font-size: 13px;
    color: var(--sf-gray-400, #9ca3af);
    margin: 0 0 24px 0;
}
</style>
