<?php
/**
 * Revisions Modal - Instructions for undoing changes via WordPress Revisions
 *
 * @package Screaming_Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get revisions status for warning display
$revisions_status = SF_Revisions_Check::get_status();
?>

<!-- Revisions Instructions Modal -->
<div id="sf-revisions-modal" class="sf-modal" style="display: none;">
    <div class="sf-modal-overlay"></div>
    <div class="sf-modal-container sf-revisions-modal-container">
        <div class="sf-modal-header">
            <h3>
                <span class="sf-modal-icon">&#8617;</span>
                <?php esc_html_e('Undo Changes via WordPress Revisions', 'screaming-fixes'); ?>
            </h3>
            <button type="button" class="sf-modal-close" aria-label="<?php esc_attr_e('Close', 'screaming-fixes'); ?>">
                &times;
            </button>
        </div>

        <div class="sf-modal-body">
            <?php if ($revisions_status['status_code'] === 'disabled') : ?>
            <div class="sf-modal-warning">
                <span class="sf-warning-icon">&#9888;</span>
                <div>
                    <strong><?php esc_html_e('Revisions are disabled on this site.', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('You may not be able to restore previous versions. Contact your hosting provider or add WP_POST_REVISIONS to wp-config.php.', 'screaming-fixes'); ?></p>
                </div>
            </div>
            <?php endif; ?>

            <p class="sf-modal-intro">
                <?php esc_html_e("You're about to open the WordPress editor for", 'screaming-fixes'); ?>
                <strong id="sf-revisions-post-title"></strong>
                <?php esc_html_e('where you can restore a previous version of this page.', 'screaming-fixes'); ?>
            </p>

            <div class="sf-modal-steps">
                <h4><?php esc_html_e('What to do:', 'screaming-fixes'); ?></h4>

                <div class="sf-step">
                    <span class="sf-step-number">1</span>
                    <div class="sf-step-content">
                        <strong><?php esc_html_e('Find the Revisions panel', 'screaming-fixes'); ?></strong>
                        <p><?php esc_html_e('In the editor sidebar, look for "Revisions" under the Post tab. You may need to scroll down or expand the sidebar.', 'screaming-fixes'); ?></p>
                    </div>
                </div>

                <div class="sf-step">
                    <span class="sf-step-number">2</span>
                    <div class="sf-step-content">
                        <strong><?php esc_html_e('Select an older version', 'screaming-fixes'); ?></strong>
                        <p><?php esc_html_e('Choose a revision from BEFORE your Screaming Fixes changes. Use the slider or click "Browse revisions" to compare versions.', 'screaming-fixes'); ?></p>
                    </div>
                </div>

                <div class="sf-step">
                    <span class="sf-step-number">3</span>
                    <div class="sf-step-content">
                        <strong><?php esc_html_e('Click "Restore This Revision"', 'screaming-fixes'); ?></strong>
                        <p><?php esc_html_e('WordPress will revert the page to that version. Your current content becomes a new revision you can restore later if needed.', 'screaming-fixes'); ?></p>
                    </div>
                </div>
            </div>

            <div class="sf-modal-tip">
                <span class="sf-tip-icon">&#128161;</span>
                <p><?php esc_html_e('Tip: Look for the revision timestamped just before you ran Screaming Fixes. The exact time is shown in your Change History.', 'screaming-fixes'); ?></p>
            </div>
        </div>

        <div class="sf-modal-footer">
            <button type="button" class="sf-button sf-button-secondary sf-modal-cancel">
                <?php esc_html_e('Cancel', 'screaming-fixes'); ?>
            </button>
            <a href="#" id="sf-open-editor-btn" class="sf-button sf-button-primary" target="_blank">
                <?php esc_html_e('Open WordPress Editor', 'screaming-fixes'); ?> &rarr;
            </a>
        </div>
    </div>
</div>
