<?php
/**
 * Tool Status cards partial for Screaming Fixes dashboard
 */

if (!defined('ABSPATH')) {
    exit;
}

// Tool configurations
$tools = [
    'broken-links' => [
        'name' => __('Broken Links', 'screaming-fixes'),
        'icon' => '&#128279;', // 🔗
        'tab' => 'broken-links',
    ],
    'redirect-chains' => [
        'name' => __('Redirect Chains', 'screaming-fixes'),
        'icon' => '&#128260;', // 🔄
        'tab' => 'redirect-chains',
    ],
    'backlinks' => [
        'name' => __('Dead Backlinks', 'screaming-fixes'),
        'icon' => '&#128281;', // 🔙
        'tab' => 'backlinks',
    ],
    'image-alt-text' => [
        'name' => __('Missing Alt Text', 'screaming-fixes'),
        'icon' => '&#128444;', // 🖼️
        'tab' => 'image-alt-text',
    ],
];

// Allow filtering
$tools = apply_filters('sf_dashboard_tools', $tools);

// Base URL for tab links
$base_url = admin_url('admin.php?page=screaming-fixes');
?>

<div class="sf-tool-status">
    <h2 class="sf-section-title"><?php esc_html_e('Tool Set', 'screaming-fixes'); ?></h2>

    <div class="sf-tool-status-grid">
        <?php foreach ($tools as $key => $tool) :
            $tab_url = add_query_arg('tab', $tool['tab'], $base_url);
        ?>
        <div class="sf-tool-card" data-tool="<?php echo esc_attr($key); ?>">
            <span class="sf-tool-icon"><?php echo $tool['icon']; ?></span>
            <span class="sf-tool-name"><?php echo esc_html($tool['name']); ?></span>
            <a href="<?php echo esc_url($tab_url); ?>" class="sf-tool-btn">
                <?php esc_html_e('Get Started', 'screaming-fixes'); ?>
            </a>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<?php
// Get recent activity from the new activity log
$recent_activity = SF_Activity_Log::get_formatted_entries(5);
$total_entries = SF_Activity_Log::get_total_count();
?>
<?php
$change_logger = new SF_Change_Logger();
$log_count = $change_logger->get_count();
?>
<div class="sf-recent-activity">
    <h2 class="sf-section-title">
        <?php esc_html_e('Change Log', 'screaming-fixes'); ?>
        <?php if ($log_count > 0) : ?>
        <button type="button" class="sf-button sf-button-secondary sf-button-small" id="sf-export-change-log" title="<?php printf(esc_attr__('Export %d change log entries as CSV', 'screaming-fixes'), $log_count); ?>">
            <span class="dashicons dashicons-download"></span>
            <?php esc_html_e('Export CSV', 'screaming-fixes'); ?>
        </button>
        <?php endif; ?>
    </h2>

    <?php if (!empty($recent_activity)) : ?>
    <div class="sf-activity-list-container">
        <ul class="sf-activity-list">
            <?php foreach ($recent_activity as $activity) : ?>
            <li class="sf-activity-item">
                <span class="sf-activity-icon"><?php echo $activity['icon']; ?></span>
                <div class="sf-activity-content">
                    <span class="sf-activity-module"><?php echo esc_html($activity['module_label']); ?></span>
                    <span class="sf-activity-description"><?php echo esc_html($activity['description']); ?></span>
                </div>
                <span class="sf-activity-time" title="<?php echo esc_attr($activity['date_formatted']); ?>">
                    <?php echo esc_html($activity['time_ago']); ?>
                </span>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <?php if ($total_entries > 5) : ?>
    <div class="sf-activity-more">
        <button type="button" class="sf-button sf-button-link sf-show-more-activity" data-showing="5" data-total="<?php echo esc_attr($total_entries); ?>">
            <?php esc_html_e('Show more', 'screaming-fixes'); ?>
        </button>
    </div>
    <?php endif; ?>

    <?php
    $stats_data = SF_Activity_Log::get_stats();
    if ($stats_data['total_fixes'] > 0) :
    ?>
    <div class="sf-activity-summary">
        <p>
            <?php
            printf(
                esc_html__('%d fixes applied total (%d today, %d this week)', 'screaming-fixes'),
                $stats_data['total_fixes'],
                $stats_data['fixes_today'],
                $stats_data['fixes_this_week']
            );
            ?>
        </p>
    </div>
    <?php endif; ?>

    <?php else : ?>
    <div class="sf-activity-empty">
        <p><?php esc_html_e('No fixes applied yet. When you apply fixes using any tool, your activity will be logged here.', 'screaming-fixes'); ?></p>
    </div>
    <?php endif; ?>
</div>
