<?php
/**
 * Drag & drop CSV upload box partial for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get optional parameters
$module = isset($args['module']) ? $args['module'] : '';
$title = isset($args['title']) ? $args['title'] : __('Upload CSV', 'screaming-fixes');
$description = isset($args['description']) ? $args['description'] : __('Drag & drop CSV here or click to browse', 'screaming-fixes');
$auto_detect = isset($args['auto_detect']) ? $args['auto_detect'] : true;
$accepted_types = isset($args['accepted_types']) ? $args['accepted_types'] : [];
$max_rows = isset($args['max_rows']) ? intval($args['max_rows']) : 0;

// Ensure accepted_types is always an array
if (!is_array($accepted_types)) {
    $accepted_types = !empty($accepted_types) ? [$accepted_types] : [];
}

// Build supported types text
if (empty($accepted_types)) {
    $supported_text = __('Supported: Broken Links, Redirect Chains, All Inlinks, Images', 'screaming-fixes');
} else {
    $supported_text = sprintf(__('Supported: %s', 'screaming-fixes'), implode(', ', $accepted_types));
}

// Unique ID for this upload box
$upload_id = 'sf-upload-' . ($module ? sanitize_key($module) : 'main');
?>

<div class="sf-upload-box" id="<?php echo esc_attr($upload_id); ?>" data-module="<?php echo esc_attr($module); ?>" data-auto-detect="<?php echo $auto_detect ? 'true' : 'false'; ?>">

    <!-- Upload Zone -->
    <div class="sf-upload-zone" tabindex="0" role="button" aria-label="<?php esc_attr_e('Upload CSV file', 'screaming-fixes'); ?>">
        <div class="sf-upload-icon">
            <span class="dashicons dashicons-upload"></span>
        </div>

        <div class="sf-upload-text">
            <p class="sf-upload-title"><?php echo esc_html($title); ?></p>
            <p class="sf-upload-description"><?php echo esc_html($description); ?></p>
        </div>

        <div class="sf-upload-supported">
            <p><?php echo esc_html($supported_text); ?></p>
            <?php if ($max_rows > 0) : ?>
                <p class="sf-upload-limit"><?php printf(esc_html__('Max %s rows per CSV file', 'screaming-fixes'), number_format_i18n($max_rows)); ?></p>
            <?php endif; ?>
        </div>

        <input
            type="file"
            class="sf-file-input"
            accept=".csv,text/csv,application/csv"
            aria-hidden="true"
        />
    </div>

    <!-- Drag Over State -->
    <div class="sf-upload-dragover" style="display: none;">
        <div class="sf-dragover-content">
            <span class="dashicons dashicons-download"></span>
            <p><?php esc_html_e('Drop your CSV file here', 'screaming-fixes'); ?></p>
        </div>
    </div>

    <!-- Progress State -->
    <div class="sf-upload-progress" style="display: none;">
        <div class="sf-progress-content">
            <div class="sf-spinner"></div>
            <p class="sf-progress-text"><?php esc_html_e('Uploading CSV...', 'screaming-fixes'); ?></p>
            <div class="sf-progress-bar">
                <div class="sf-progress-fill" style="width: 0%;"></div>
            </div>
            <p class="sf-progress-percent">0%</p>
        </div>
    </div>

    <!-- Processing State -->
    <div class="sf-upload-processing" style="display: none;">
        <div class="sf-processing-content">
            <div class="sf-spinner"></div>
            <p class="sf-processing-text"><?php esc_html_e('Processing CSV...', 'screaming-fixes'); ?></p>
            <p class="sf-processing-detail"><?php esc_html_e('Detecting file type and analyzing data', 'screaming-fixes'); ?></p>
        </div>
    </div>

    <!-- Success State -->
    <div class="sf-upload-success" style="display: none;">
        <div class="sf-success-content">
            <span class="sf-success-icon">&#10003;</span>
            <p class="sf-success-text"><?php esc_html_e('Upload Complete!', 'screaming-fixes'); ?></p>
            <p class="sf-success-detail"></p>
            <button type="button" class="sf-button sf-button-primary sf-view-results">
                <?php esc_html_e('View Results', 'screaming-fixes'); ?>
                <span class="sf-arrow">&rarr;</span>
            </button>
        </div>
    </div>

    <!-- Error State -->
    <div class="sf-upload-error" style="display: none;">
        <div class="sf-error-content">
            <span class="sf-error-icon">&#10007;</span>
            <p class="sf-error-text"><?php esc_html_e('Upload Failed', 'screaming-fixes'); ?></p>
            <p class="sf-error-detail"></p>
            <button type="button" class="sf-button sf-button-secondary sf-try-again">
                <?php esc_html_e('Try Again', 'screaming-fixes'); ?>
            </button>
        </div>
    </div>

</div>

<!-- File Info (shown after successful detection) -->
<div class="sf-file-info" id="<?php echo esc_attr($upload_id); ?>-info" style="display: none;">
    <div class="sf-file-info-content">
        <div class="sf-file-icon">
            <span class="dashicons dashicons-media-spreadsheet"></span>
        </div>
        <div class="sf-file-details">
            <p class="sf-file-name"></p>
            <p class="sf-file-meta">
                <span class="sf-file-type"></span>
                <span class="sf-file-rows"></span>
            </p>
        </div>
        <button type="button" class="sf-button sf-button-link sf-remove-file" aria-label="<?php esc_attr_e('Remove file', 'screaming-fixes'); ?>">
            <span class="dashicons dashicons-dismiss"></span>
        </button>
    </div>
</div>
