<?php
/**
 * Welcome message partial for Screaming Fixes dashboard
 *
 * Displays a one-time welcome message that can be permanently dismissed.
 * Uses user meta to track dismissal state.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Check if user has dismissed the welcome message
$user_id = get_current_user_id();
$is_dismissed = get_user_meta($user_id, 'sf_welcome_dismissed', true);

// Don't render if already dismissed
if ($is_dismissed) {
    return;
}

$settings_url = admin_url('admin.php?page=screaming-fixes&tab=settings');
?>

<div class="sf-welcome-message" id="sf-welcome-message">
    <button type="button" class="sf-welcome-dismiss" id="sf-welcome-dismiss" aria-label="<?php esc_attr_e('Dismiss welcome message', 'screaming-fixes'); ?>">
        <span class="dashicons dashicons-no-alt"></span>
    </button>

    <div class="sf-welcome-header">
        <span class="sf-welcome-icon">&#128075;</span>
        <h3><?php esc_html_e('Welcome to Screaming Fixes!', 'screaming-fixes'); ?></h3>
    </div>

    <div class="sf-welcome-content">
        <p><?php esc_html_e("I'm Brett Lindenberg, and I built this tool to turn your Screaming Frog crawl data into one-click WordPress fixes. Export a CSV report from Screaming Frog, upload it here, and Screaming Fixes will identify the report type, show you proposed changes for review, and publish approved fixes directly to your site — complete with a detailed changelog.", 'screaming-fixes'); ?></p>

        <p>
            <?php esc_html_e("We support popular reports including Broken Links, Redirect Chains, Page Titles, and Meta Descriptions, with more coming. Each tool includes instructions for pulling the right report. You can also make edits in a spreadsheet before uploading if you prefer to work that way.", 'screaming-fixes'); ?>
            <strong>
                <?php
                printf(
                    /* translators: %s: link to Screaming Frog website */
                    esc_html__("Note: You'll need a %s to get full value from most exports.", 'screaming-fixes'),
                    '<a href="https://www.screamingfrog.co.uk/seo-spider/" target="_blank" rel="noopener">' . esc_html__('Screaming Frog license', 'screaming-fixes') . '</a>'
                );
                ?>
            </strong>
        </p>

        <p><?php esc_html_e("Beyond Screaming Frog reports, I've built standalone tools that don't require any CSV upload. Backlink Reclaim helps you recover backlinks lost to 404s and redirects — fast. Internal Link Builder finds linking opportunities across your content and lets you add them in one click, improving link equity site-wide.", 'screaming-fixes'); ?></p>

        <p>
            <?php
            printf(
                /* translators: %s: link to settings page */
                esc_html__('Before you dive in, head to %s to add your API keys. Screaming Fixes uses a bring-your-own-key model, so connecting your integrations unlocks the full power of this tool at no extra cost.', 'screaming-fixes'),
                '<a href="' . esc_url($settings_url) . '">' . esc_html__('Settings', 'screaming-fixes') . '</a>'
            );
            ?>
        </p>

        <p class="sf-welcome-contact">
            <?php
            printf(
                /* translators: %s: email address */
                esc_html__('Missing a report you rely on? Have questions or feedback? Email me directly at %s — I read every message.', 'screaming-fixes'),
                '<a href="mailto:brett.lindenberg@gmail.com">brett.lindenberg@gmail.com</a>'
            );
            ?>
        </p>

        <p class="sf-welcome-disclaimer">
            <em><?php esc_html_e("Disclaimer: Screaming Fixes is an independent project with no affiliation to or sponsorship from Screaming Frog. I'm just someone who's used the tool for 10+ years and wanted to make acting on crawl data faster.", 'screaming-fixes'); ?></em>
        </p>
    </div>
</div>
