<?php
/**
 * Settings page view for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current settings
$claude_api_key = get_option('sf_claude_api_key', '');
$dataforseo_login = get_option('sf_dataforseo_login', '');
$dataforseo_password = get_option('sf_dataforseo_password', '');
$preferred_redirect = get_option('sf_preferred_redirect_plugin', 'auto');
$debug_mode = get_option('sf_debug_mode', false);
$subscribed_email = get_option('sf_email_subscribed', '');

// Get redirect plugin status
$redirect_manager = new SF_Redirect_Manager();
$redirect_status = $redirect_manager->get_capability_status();

// Get detected plugins
$plugin_detector = new SF_Plugin_Detector();
$active_seo_plugins = $plugin_detector->get_active_seo_plugins();

// Get revisions status
$revisions_status = SF_Revisions_Check::get_status();
?>

<div class="sf-settings-page">

    <!-- Plugin Integrations -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('Plugin Integrations', 'screaming-fixes'); ?></h2>
        <p class="sf-section-description">
            <?php esc_html_e('These plugins extend what Screaming Fixes can do.', 'screaming-fixes'); ?>
        </p>

        <!-- Redirects Section -->
        <div class="sf-integration-box">
            <h3><?php esc_html_e('Redirects', 'screaming-fixes'); ?></h3>
            <p class="sf-integration-note">
                <?php esc_html_e('Required for: Backlink Reclaim, Redirect Chain fixes', 'screaming-fixes'); ?>
            </p>

            <div class="sf-plugin-list">
                <?php
                $redirect_plugins = [
                    'rank_math' => ['name' => 'Rank Math', 'class' => 'RankMath'],
                    'redirection' => ['name' => 'Redirection', 'class' => 'Red_Item'],
                    'yoast_premium' => ['name' => 'Yoast Premium', 'class' => 'WPSEO_Redirect'],
                ];

                foreach ($redirect_plugins as $key => $plugin) :
                    $is_active = $redirect_manager->is_plugin_available($key);
                ?>
                <div class="sf-plugin-item <?php echo $is_active ? 'sf-plugin-active' : 'sf-plugin-inactive'; ?>">
                    <span class="sf-plugin-status">
                        <?php if ($is_active) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-inactive">&#9744;</span>
                        <?php endif; ?>
                    </span>
                    <span class="sf-plugin-name"><?php echo esc_html($plugin['name']); ?></span>
                    <span class="sf-plugin-state">
                        <?php if ($is_active) : ?>
                            <?php esc_html_e('Detected & Ready', 'screaming-fixes'); ?>
                        <?php else : ?>
                            <?php esc_html_e('Not installed', 'screaming-fixes'); ?>
                        <?php endif; ?>
                    </span>
                </div>
                <?php endforeach; ?>
            </div>

            <div class="sf-integration-status <?php echo $redirect_status['has_capability'] ? 'sf-status-ready' : 'sf-status-warning'; ?>">
                <?php if ($redirect_status['has_capability']) : ?>
                    <span class="sf-status-icon sf-status-success">&#10003;</span>
                    <?php
                    printf(
                        esc_html__('Ready - Using %s for redirects', 'screaming-fixes'),
                        esc_html($redirect_status['active_plugin_name'])
                    );
                    ?>
                <?php else : ?>
                    <span class="sf-status-icon sf-status-warning">&#9888;</span>
                    <?php esc_html_e('No redirect plugin detected. Install Rank Math or Redirection to enable redirect features.', 'screaming-fixes'); ?>
                <?php endif; ?>
            </div>

            <?php
            // Only show preference selector if multiple redirect plugins are available
            $available_plugins = array_filter($redirect_plugins, function($key) use ($redirect_manager) {
                return $redirect_manager->is_plugin_available($key);
            }, ARRAY_FILTER_USE_KEY);

            // Get the currently active plugin (what's actually being used)
            $active_plugin = $redirect_manager->get_redirect_plugin();

            if (count($available_plugins) > 1) : ?>
            <div class="sf-select-field sf-redirect-preference">
                <label for="sf-preferred-redirect">
                    <?php esc_html_e('Use:', 'screaming-fixes'); ?>
                </label>
                <select id="sf-preferred-redirect" class="sf-select sf-setting-select" data-setting="preferred_redirect_plugin">
                    <?php foreach ($redirect_status['plugins'] as $key => $plugin) :
                        if ($redirect_manager->is_plugin_available($key)) : ?>
                    <option value="<?php echo esc_attr($key); ?>" <?php selected($active_plugin, $key); ?>>
                        <?php echo esc_html($plugin['name']); ?>
                    </option>
                    <?php endif; endforeach; ?>
                </select>
                <button type="button" id="sf-save-redirect-pref" class="sf-button sf-button-secondary sf-button-small">
                    <?php esc_html_e('Save', 'screaming-fixes'); ?>
                </button>
            </div>
            <?php endif; ?>
        </div>

        <!-- SEO Plugins Section -->
        <div class="sf-integration-box">
            <h3><?php esc_html_e('Meta Tags (SEO Titles & Descriptions)', 'screaming-fixes'); ?></h3>
            <p class="sf-integration-note">
                <?php esc_html_e('Required for: Meta Description Fixer, Title Fixer', 'screaming-fixes'); ?>
            </p>

            <div class="sf-plugin-list">
                <?php
                $seo_plugins = [
                    'rank-math' => 'Rank Math',
                    'yoast' => 'Yoast SEO',
                    'aioseo' => 'All in One SEO',
                ];

                foreach ($seo_plugins as $key => $name) :
                    $is_active = isset($active_seo_plugins[$key]);
                ?>
                <div class="sf-plugin-item <?php echo $is_active ? 'sf-plugin-active' : 'sf-plugin-inactive'; ?>">
                    <span class="sf-plugin-status">
                        <?php if ($is_active) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-inactive">&#9744;</span>
                        <?php endif; ?>
                    </span>
                    <span class="sf-plugin-name"><?php echo esc_html($name); ?></span>
                    <span class="sf-plugin-state">
                        <?php if ($is_active) : ?>
                            <?php esc_html_e('Detected & Ready', 'screaming-fixes'); ?>
                        <?php else : ?>
                            <?php esc_html_e('Not installed', 'screaming-fixes'); ?>
                        <?php endif; ?>
                    </span>
                </div>
                <?php endforeach; ?>
            </div>

            <div class="sf-integration-status <?php echo !empty($active_seo_plugins) ? 'sf-status-ready' : 'sf-status-warning'; ?>">
                <?php if (!empty($active_seo_plugins)) : ?>
                    <span class="sf-status-icon sf-status-success">&#10003;</span>
                    <?php
                    printf(
                        esc_html__('Ready - Using %s for meta tags', 'screaming-fixes'),
                        esc_html(reset($active_seo_plugins))
                    );
                    ?>
                <?php else : ?>
                    <span class="sf-status-icon sf-status-warning">&#9888;</span>
                    <?php esc_html_e('No SEO plugin detected.', 'screaming-fixes'); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Change History -->
    <div class="sf-settings-section">
        <h2>
            <span class="sf-section-icon">&#8617;</span>
            <?php esc_html_e('Change History', 'screaming-fixes'); ?>
        </h2>

        <!-- Revisions Status -->
        <div class="sf-revisions-status sf-revisions-<?php echo esc_attr($revisions_status['status_code']); ?>">
            <div class="sf-revisions-status-header">
                <span class="sf-revisions-label"><?php esc_html_e('WordPress Revisions:', 'screaming-fixes'); ?></span>
                <?php echo SF_Revisions_Check::get_status_badge_html(); ?>
            </div>
            <p class="sf-revisions-message"><?php echo esc_html($revisions_status['message']); ?></p>
            <?php if (!empty($revisions_status['details'])) : ?>
            <ul class="sf-revisions-details">
                <?php foreach ($revisions_status['details'] as $detail) : ?>
                <li><?php echo esc_html($detail); ?></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
            <?php if ($revisions_status['status_code'] === 'disabled') : ?>
            <div class="sf-revisions-help">
                <strong><?php esc_html_e('To enable revisions, add this to wp-config.php:', 'screaming-fixes'); ?></strong>
                <code>define('WP_POST_REVISIONS', true);</code>
            </div>
            <?php endif; ?>
        </div>

        <!-- Restore Points Section -->
        <div class="sf-restore-points-section">
            <h3 class="sf-restore-points-title">
                <span class="sf-restore-icon">&#128260;</span>
                <?php esc_html_e('Restore Points', 'screaming-fixes'); ?>
            </h3>
            <p class="sf-restore-points-description">
                <?php esc_html_e('Undo entire batches of changes with one click. Each "Apply All Fixes" creates a restore point.', 'screaming-fixes'); ?>
            </p>
            <div id="sf-restore-points-list" class="sf-restore-points-list">
                <div class="sf-restore-points-loading">
                    <span class="sf-spinner"></span>
                    <?php esc_html_e('Loading restore points...', 'screaming-fixes'); ?>
                </div>
            </div>
        </div>

        <!-- Change Log Section -->
        <?php
        $change_logger = new SF_Change_Logger();
        $log_entry_count = $change_logger->get_count();
        $max_entries = SF_Change_Logger::MAX_ENTRIES;
        ?>
        <div class="sf-change-log-section">
            <h3 class="sf-change-log-title">
                <span class="sf-restore-icon">&#128203;</span>
                <?php esc_html_e('Change Log', 'screaming-fixes'); ?>
            </h3>
            <p class="sf-change-log-description">
                <?php esc_html_e('A rolling record of all fixes applied across all tools. Export as CSV for your records.', 'screaming-fixes'); ?>
            </p>
            <div class="sf-change-log-info">
                <span class="sf-change-log-count">
                    <?php printf(
                        esc_html__('%s of %s entries', 'screaming-fixes'),
                        '<strong class="sf-log-entry-count">' . esc_html(number_format_i18n($log_entry_count)) . '</strong>',
                        esc_html(number_format_i18n($max_entries))
                    ); ?>
                </span>
                <div class="sf-change-log-actions">
                    <?php if ($log_entry_count > 0) : ?>
                    <button type="button" class="sf-button sf-button-secondary sf-button-small" id="sf-export-change-log">
                        <span class="dashicons dashicons-download"></span>
                        <?php esc_html_e('Export CSV', 'screaming-fixes'); ?>
                    </button>
                    <button type="button" class="sf-button sf-button-danger sf-button-small" id="sf-clear-change-log">
                        <span class="dashicons dashicons-trash"></span>
                        <?php esc_html_e('Clear Log', 'screaming-fixes'); ?>
                    </button>
                    <?php else : ?>
                    <span class="sf-change-log-empty"><?php esc_html_e('No entries yet. Entries will appear here as you apply fixes.', 'screaming-fixes'); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- AI Suggestions -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('AI Suggestions', 'screaming-fixes'); ?></h2>

        <div class="sf-settings-box">
            <h3><?php esc_html_e('Claude API Key', 'screaming-fixes'); ?></h3>
            <p class="sf-settings-description">
                <?php esc_html_e('Powers AI-suggested fixes for broken links, alt text, and redirect destinations.', 'screaming-fixes'); ?>
            </p>

            <div class="sf-api-key-field">
                <input
                    type="password"
                    id="sf-claude-api-key"
                    class="sf-input sf-input-wide"
                    value="<?php echo esc_attr($claude_api_key); ?>"
                    placeholder="sk-ant-..."
                    autocomplete="off"
                />
                <button type="button" id="sf-toggle-api-key" class="sf-button sf-button-secondary sf-button-icon" title="<?php esc_attr_e('Show/Hide', 'screaming-fixes'); ?>">
                    <span class="dashicons dashicons-visibility"></span>
                </button>
                <button type="button" id="sf-test-api-key" class="sf-button sf-button-secondary">
                    <?php esc_html_e('Test', 'screaming-fixes'); ?>
                </button>
                <button type="button" id="sf-save-api-key" class="sf-button sf-button-primary">
                    <?php esc_html_e('Save', 'screaming-fixes'); ?>
                </button>
            </div>

            <div id="sf-api-key-status" class="sf-api-status" style="display: none;"></div>

            <p class="sf-settings-help">
                <?php
                printf(
                    esc_html__("Don't have a key? Get one at %s", 'screaming-fixes'),
                    '<a href="https://console.anthropic.com" target="_blank" rel="noopener">console.anthropic.com</a>'
                );
                ?>
            </p>
        </div>
    </div>

    <!-- Backlink Reclaim API -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('Backlink Reclaim API', 'screaming-fixes'); ?></h2>

        <div class="sf-settings-box">
            <h3>
                <span class="sf-settings-icon">&#128281;</span>
                <?php esc_html_e('DataForSEO Credentials', 'screaming-fixes'); ?>
            </h3>
            <p class="sf-settings-description">
                <?php esc_html_e('Users get one complimentary backlink scan every 24 hours. For unlimited scans create an account.', 'screaming-fixes'); ?>
            </p>

            <div class="sf-api-credentials-grid">
                <div class="sf-api-field">
                    <label for="sf-dataforseo-login"><?php esc_html_e('API Login', 'screaming-fixes'); ?></label>
                    <input
                        type="text"
                        id="sf-dataforseo-login"
                        class="sf-input sf-input-wide"
                        value="<?php echo esc_attr($dataforseo_login); ?>"
                        placeholder="your@email.com"
                        autocomplete="off"
                    />
                </div>
                <div class="sf-api-field">
                    <label for="sf-dataforseo-password"><?php esc_html_e('API Password', 'screaming-fixes'); ?></label>
                    <div class="sf-password-field">
                        <input
                            type="password"
                            id="sf-dataforseo-password"
                            class="sf-input sf-input-wide"
                            value="<?php echo esc_attr($dataforseo_password); ?>"
                            placeholder="<?php esc_attr_e('Your API password', 'screaming-fixes'); ?>"
                            autocomplete="off"
                        />
                        <button type="button" id="sf-toggle-dataforseo-password" class="sf-button sf-button-secondary sf-button-icon" title="<?php esc_attr_e('Show/Hide', 'screaming-fixes'); ?>">
                            <span class="dashicons dashicons-visibility"></span>
                        </button>
                    </div>
                </div>
            </div>

            <div class="sf-api-actions">
                <button type="button" id="sf-test-dataforseo" class="sf-button sf-button-secondary">
                    <?php esc_html_e('Test Connection', 'screaming-fixes'); ?>
                </button>
                <button type="button" id="sf-save-dataforseo" class="sf-button sf-button-primary">
                    <?php esc_html_e('Save Credentials', 'screaming-fixes'); ?>
                </button>
            </div>

            <div id="sf-dataforseo-status" class="sf-api-status" style="display: none;"></div>

            <p class="sf-settings-help">
                <?php
                printf(
                    esc_html__("Don't have credentials? %s to create an account.", 'screaming-fixes'),
                    '<a href="https://dataforseo.com/" target="_blank" rel="noopener">' . esc_html__('Visit DataForSEO', 'screaming-fixes') . '</a>'
                );
                ?>
            </p>

        </div>
    </div>

    <!-- Email Subscription -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('Stay Updated', 'screaming-fixes'); ?></h2>

        <div class="sf-settings-box">
            <p class="sf-settings-description">
                <?php esc_html_e('Get power user tips, be first to know about new features, and request custom tools for your workflow. 1-2 emails per month — no junk.', 'screaming-fixes'); ?>
            </p>

            <div class="sf-email-field">
                <input
                    type="email"
                    id="sf-subscribe-email"
                    class="sf-input sf-input-wide"
                    value="<?php echo esc_attr($subscribed_email); ?>"
                    placeholder="your@email.com"
                />
                <button type="button" id="sf-subscribe-btn" class="sf-button sf-button-primary">
                    <?php esc_html_e('Subscribe', 'screaming-fixes'); ?>
                </button>
            </div>

            <div id="sf-subscribe-status" class="sf-subscribe-status" style="display: none;"></div>
        </div>
    </div>

    <!-- Server Configuration -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('Server Configuration', 'screaming-fixes'); ?></h2>

        <div class="sf-settings-box">
            <p class="sf-settings-description">
                <?php esc_html_e('These PHP settings affect CSV upload limits. If uploads fail for large files, you may need to adjust these values.', 'screaming-fixes'); ?>
            </p>

            <?php
            // Get PHP settings
            $upload_max = ini_get('upload_max_filesize');
            $post_max = ini_get('post_max_size');
            $max_execution = ini_get('max_execution_time');
            $memory_limit = ini_get('memory_limit');

            // Convert to bytes for comparison
            $upload_bytes = wp_convert_hr_to_bytes($upload_max);
            $post_bytes = wp_convert_hr_to_bytes($post_max);
            $recommended_bytes = 50 * 1024 * 1024; // 50MB

            // Determine status
            $upload_ok = $upload_bytes >= $recommended_bytes;
            $post_ok = $post_bytes >= $recommended_bytes;
            ?>

            <div class="sf-server-config">
                <div class="sf-config-item <?php echo $upload_ok ? 'sf-config-ok' : 'sf-config-warning'; ?>">
                    <span class="sf-config-label">upload_max_filesize</span>
                    <span class="sf-config-value"><?php echo esc_html($upload_max); ?></span>
                    <span class="sf-config-status">
                        <?php if ($upload_ok) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-warning">&#9888;</span>
                            <span class="sf-config-note"><?php esc_html_e('Recommend 50M+', 'screaming-fixes'); ?></span>
                        <?php endif; ?>
                    </span>
                </div>

                <div class="sf-config-item <?php echo $post_ok ? 'sf-config-ok' : 'sf-config-warning'; ?>">
                    <span class="sf-config-label">post_max_size</span>
                    <span class="sf-config-value"><?php echo esc_html($post_max); ?></span>
                    <span class="sf-config-status">
                        <?php if ($post_ok) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-warning">&#9888;</span>
                            <span class="sf-config-note"><?php esc_html_e('Recommend 50M+', 'screaming-fixes'); ?></span>
                        <?php endif; ?>
                    </span>
                </div>

                <div class="sf-config-item">
                    <span class="sf-config-label">max_execution_time</span>
                    <span class="sf-config-value"><?php echo esc_html($max_execution); ?>s</span>
                    <span class="sf-config-status">
                        <?php if ((int) $max_execution >= 120 || (int) $max_execution === 0) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-warning">&#9888;</span>
                            <span class="sf-config-note"><?php esc_html_e('Recommend 120s+ for large files', 'screaming-fixes'); ?></span>
                        <?php endif; ?>
                    </span>
                </div>

                <div class="sf-config-item">
                    <span class="sf-config-label">memory_limit</span>
                    <span class="sf-config-value"><?php echo esc_html($memory_limit); ?></span>
                    <span class="sf-config-status">
                        <?php if (wp_convert_hr_to_bytes($memory_limit) >= 256 * 1024 * 1024) : ?>
                            <span class="sf-status-icon sf-status-success">&#10003;</span>
                        <?php else : ?>
                            <span class="sf-status-icon sf-status-warning">&#9888;</span>
                            <span class="sf-config-note"><?php esc_html_e('Recommend 256M+ for large files', 'screaming-fixes'); ?></span>
                        <?php endif; ?>
                    </span>
                </div>
            </div>

            <?php if (!$upload_ok || !$post_ok) : ?>
            <div class="sf-config-help">
                <span class="dashicons dashicons-info"></span>
                <div>
                    <strong><?php esc_html_e('Need to increase limits?', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Contact your hosting provider, or add these lines to your php.ini or .htaccess file:', 'screaming-fixes'); ?></p>
                    <code>
                        upload_max_filesize = 50M<br>
                        post_max_size = 50M<br>
                        max_execution_time = 300
                    </code>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Advanced Settings -->
    <div class="sf-settings-section">
        <h2><?php esc_html_e('Advanced', 'screaming-fixes'); ?></h2>

        <div class="sf-settings-box">
            <div class="sf-checkbox-list sf-advanced-options">
                <label class="sf-checkbox-label">
                    <input
                        type="checkbox"
                        id="sf-debug-mode"
                        class="sf-setting-checkbox"
                        data-setting="debug_mode"
                        <?php checked($debug_mode); ?>
                    />
                    <?php esc_html_e('Debug mode (for troubleshooting)', 'screaming-fixes'); ?>
                </label>
            </div>

            <div class="sf-advanced-actions">
                <button type="button" id="sf-save-advanced" class="sf-button sf-button-primary">
                    <?php esc_html_e('Save Settings', 'screaming-fixes'); ?>
                </button>
                <span id="sf-advanced-status" class="sf-save-status" style="display: none;"></span>
            </div>
        </div>
    </div>

</div>
