<?php
/**
 * Module loader for Screaming Fixes
 */

if (!defined('ABSPATH')) {
    exit;
}

class SF_Module_Loader {
    /**
     * Array of loaded modules
     */
    private static $modules = [];

    /**
     * Initialize and load all modules
     */
    public static function init() {
        self::load_base_module();
        self::load_modules();
    }

    /**
     * Load the base module class
     */
    private static function load_base_module() {
        require_once SF_PLUGIN_DIR . 'includes/abstracts/class-module.php';
    }

    /**
     * Load all available modules
     */
    private static function load_modules() {
        $modules_dir = SF_PLUGIN_DIR . 'modules/';

        if (!is_dir($modules_dir)) {
            return;
        }

        $module_dirs = array_filter(
            scandir($modules_dir),
            function ($item) use ($modules_dir) {
                return is_dir($modules_dir . $item) && $item !== '.' && $item !== '..';
            }
        );

        foreach ($module_dirs as $module_dir) {
            $module_class_file = $modules_dir . $module_dir . '/class-' . $module_dir . '.php';
            
            if (file_exists($module_class_file)) {
                require_once $module_class_file;
                
                // Convert dir name to class name (e.g., broken-links -> SF_Broken_Links)
                $class_name = 'SF_' . str_replace('-', '_', ucwords($module_dir, '-'));
                
                if (class_exists($class_name)) {
                    self::$modules[$module_dir] = new $class_name();
                }
            }
        }
    }

    /**
     * Get a specific module
     */
    public static function get_module($module_name) {
        return self::$modules[$module_name] ?? null;
    }

    /**
     * Get all loaded modules
     */
    public static function get_modules() {
        return self::$modules;
    }
}
