<?php
/**
 * Instructions partial for Backlink Evaluator module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128202;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How Backlink Evaluator Works', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <h4><?php esc_html_e('What This Tool Does', 'screaming-fixes'); ?></h4>
            <p><?php esc_html_e('Backlink Evaluator gives you a complete view of your backlink profile. See who links to you, track lost links, and export detailed data for analysis or client reporting.', 'screaming-fixes'); ?></p>

            <h4><?php esc_html_e('How It Works', 'screaming-fixes'); ?></h4>
            <ol class="sf-numbered-list">
                <li><strong><?php esc_html_e('Scan', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Click "Run Backlink Check" to pull live data from the DataForSEO API', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Review', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Check summary cards and filter the table to find actionable insights', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Export', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Download the full 24-column CSV for detailed analysis', 'screaming-fixes'); ?></li>
            </ol>

            <h4><?php esc_html_e('Free vs. Unlimited Scans', 'screaming-fixes'); ?></h4>
            <ul class="sf-bullet-list">
                <li><strong><?php esc_html_e('Free:', 'screaming-fixes'); ?></strong> <?php esc_html_e('1 scan per 7 days, up to 1,000 backlinks', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Unlimited:', 'screaming-fixes'); ?></strong> <?php printf(
                    esc_html__('Add your own %s API key in Settings', 'screaming-fixes'),
                    '<a href="https://dataforseo.com/" target="_blank" rel="noopener">DataForSEO</a>'
                ); ?></li>
            </ul>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('Use the "Lost Links" filter to find reclamation opportunities - reaching out to restore these links is high-ROI link building.', 'screaming-fixes'); ?>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Understanding the columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><strong><?php esc_html_e('Referring Domain', 'screaming-fixes'); ?></strong> - <?php esc_html_e('The website linking to you', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Anchor Text', 'screaming-fixes'); ?></strong> - <?php esc_html_e('The clickable link text', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Attr', 'screaming-fixes'); ?></strong> - <?php esc_html_e('DF=dofollow, NF=nofollow, SP=sponsored, UGC=user generated', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Rank', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Page quality score (0-1000)', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Status', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Live, Lost, or New', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>

        <div class="sf-instructions-note sf-instructions-api-note">
            <span class="sf-note-icon">&#128196;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('CSV Export:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('The full export includes 24 columns with domain/page rank, spam scores, link context, semantic location, and HTTP status codes.', 'screaming-fixes'); ?>
            </div>
        </div>
    </div>
</div>
