<?php
/**
 * Instructions partial for Backlink Reclaim module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128209;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How Backlink Reclaim Works', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <h4><?php esc_html_e('What This Tool Does', 'screaming-fixes'); ?></h4>
            <p><?php esc_html_e('Backlink Reclaim finds external websites linking to pages on your site that no longer exist (404 errors). These are lost opportunities - other sites are sending you traffic and SEO value, but visitors hit a dead end.', 'screaming-fixes'); ?></p>

            <h4><?php esc_html_e('How It Works', 'screaming-fixes'); ?></h4>
            <ol class="sf-numbered-list">
                <li><strong><?php esc_html_e('Scan', 'screaming-fixes'); ?></strong> - <?php esc_html_e('We check your domain for backlinks pointing to 404 pages', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Review', 'screaming-fixes'); ?></strong> - <?php esc_html_e('See which dead pages have the most valuable backlinks', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Fix', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Create redirects to send visitors (and link equity) to the right pages', 'screaming-fixes'); ?></li>
            </ol>

            <h4><?php esc_html_e('Free vs. Unlimited Scans', 'screaming-fixes'); ?></h4>
            <ul class="sf-bullet-list">
                <li><strong><?php esc_html_e('Free:', 'screaming-fixes'); ?></strong> <?php esc_html_e('1 scan per day, up to 1,000 URLs checked', 'screaming-fixes'); ?></li>
                <li><strong><?php esc_html_e('Unlimited:', 'screaming-fixes'); ?></strong> <?php printf(
                    esc_html__('Add your own %s API key in Settings', 'screaming-fixes'),
                    '<a href="https://dataforseo.com/" target="_blank" rel="noopener">DataForSEO</a>'
                ); ?></li>
            </ul>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('Focus on redirecting pages with the most backlinks first - they have the most SEO value to reclaim.', 'screaming-fixes'); ?>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Understanding the results:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><strong><?php esc_html_e('Dead Page', 'screaming-fixes'); ?></strong> - <?php esc_html_e('The URL on your site returning 404', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Backlinks', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Number of external links pointing to this page', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Top Referrers', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Domains with the most links to this page', 'screaming-fixes'); ?></li>
                    <li><strong><?php esc_html_e('Redirect To', 'screaming-fixes'); ?></strong> - <?php esc_html_e('Where to send visitors (and link equity)', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
