<?php
/**
 * Screaming Frog Export Instructions for Broken Links
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box">
    <ol class="sf-instructions-list">
        <li>
            <strong><?php esc_html_e('Open Screaming Frog', 'screaming-fixes'); ?></strong>
            <?php esc_html_e('and crawl your site', 'screaming-fixes'); ?>
        </li>
        <li>
            <strong><?php esc_html_e('Go to:', 'screaming-fixes'); ?></strong>
            <code>Bulk Export &rarr; Response Codes Internal &amp; External &rarr; Client Error (4xx) Inlinks</code>
        </li>
        <li>
            <strong><?php esc_html_e('Save the CSV file', 'screaming-fixes'); ?></strong>
            <?php esc_html_e('to your computer', 'screaming-fixes'); ?>
        </li>
        <li>
            <strong><?php esc_html_e('Upload it above', 'screaming-fixes'); ?></strong>
            <?php esc_html_e("and we'll find all posts containing those broken links", 'screaming-fixes'); ?>
        </li>
    </ol>

    <div class="sf-instructions-tip">
        <span class="dashicons dashicons-lightbulb"></span>
        <p>
            <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
            <?php esc_html_e('You can also use the "All Inlinks" export and filter by status code. We\'ll auto-detect 4xx errors.', 'screaming-fixes'); ?>
        </p>
    </div>

    <div class="sf-instructions-warning">
        <span class="dashicons dashicons-warning"></span>
        <p>
            <strong><?php esc_html_e('File Size Limit:', 'screaming-fixes'); ?></strong>
            <?php esc_html_e('CSV files are limited to 5,000 rows maximum. For larger exports, split your file into batches of 5,000 rows or fewer. In Screaming Frog or Excel, you can filter by status code or sort by source URL to create logical batches.', 'screaming-fixes'); ?>
        </p>
    </div>

    <div class="sf-instructions-formats">
        <p class="sf-formats-label"><strong><?php esc_html_e('Supported CSV columns:', 'screaming-fixes'); ?></strong></p>
        <ul class="sf-formats-list">
            <li><code>Destination</code> or <code>URL</code> - <?php esc_html_e('The broken link URL', 'screaming-fixes'); ?></li>
            <li><code>Source</code> - <?php esc_html_e('Where the link was found (optional)', 'screaming-fixes'); ?></li>
            <li><code>Status Code</code> - <?php esc_html_e('HTTP response code (optional)', 'screaming-fixes'); ?></li>
            <li><code>Anchor</code> - <?php esc_html_e('Link anchor text (optional)', 'screaming-fixes'); ?></li>
        </ul>
    </div>

    <hr class="sf-instructions-divider" />

    <div class="sf-instructions-alt">
        <strong><?php esc_html_e('Prefer working in spreadsheets?', 'screaming-fixes'); ?></strong>
        <p><?php esc_html_e('Add a Broken_Link_Fix column to your Screaming Frog export to specify replacement URLs directly in the spreadsheet. This lets you do all your work in Excel or Google Sheets before uploading.', 'screaming-fixes'); ?></p>
        <p><?php esc_html_e('Just drop the CSV into this tool and Screaming Fixes will automatically detect the format and apply your fixes in bulk.', 'screaming-fixes'); ?></p>

        <div class="sf-example-table">
            <strong><?php esc_html_e('Example:', 'screaming-fixes'); ?></strong>
            <table class="sf-csv-example">
                <thead>
                    <tr>
                        <th>Source</th>
                        <th>Destination</th>
                        <th>Broken_Link_Fix</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>https://example.com/blog/post-1/</td>
                        <td>https://example.com/old-page/</td>
                        <td>https://example.com/new-page/</td>
                    </tr>
                    <tr>
                        <td>https://example.com/about/</td>
                        <td>https://external.com/broken-link</td>
                        <td>https://external.com/working-link</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <p class="sf-example-note"><?php esc_html_e('Rows without a Broken_Link_Fix value will be skipped. You can also use New_Destination, Fixed_URL, or Replacement_URL as column names.', 'screaming-fixes'); ?></p>
    </div>
</div>
