<?php
/**
 * Instructions partial for Image Alt Text module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128444;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How to export Images Missing Alt Text from Screaming Frog', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Crawl your website', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Open Screaming Frog SEO Spider and enter your website URL. Click "Start" to begin the crawl.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Enable image crawling', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Go to Configuration → Spider → Extraction and ensure "Images" is checked. This ensures all images are discovered during the crawl.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Export Images Missing Alt Text', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('After the crawl completes, go to Bulk Export → Images → Images Missing Alt Attribute & Text Inlinks. Save the CSV file.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">4</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Upload the CSV here', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Drag and drop the exported CSV file into the upload area above, or click to browse.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('For the best results, include the "Inlinks" data when exporting. This helps identify which pages contain each image. In Screaming Frog, right-click on the Images tab and select "Export All Inlinks" to include source page information.', 'screaming-fixes'); ?>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Expected CSV columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><code>Destination</code> - <?php esc_html_e('The image URL', 'screaming-fixes'); ?></li>
                    <li><code>Alt Text</code> - <?php esc_html_e('Current alt text (empty for missing)', 'screaming-fixes'); ?></li>
                    <li><code>Source</code> - <?php esc_html_e('Page URL where image appears', 'screaming-fixes'); ?></li>
                    <li><code>Link Position</code> - <?php esc_html_e('Where image is located (Content, Navigation, Footer)', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>

        <!-- Bulk Fix Help -->
        <div class="sf-bulk-fix-help">
            <div class="sf-instructions-note">
                <span class="sf-note-icon">&#128221;</span>
                <div class="sf-note-content">
                    <strong><?php esc_html_e('Prefer working in spreadsheets?', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Add a New_Alt_Text column to your Screaming Frog export to specify alt text directly. Rows without a New_Alt_Text value are automatically skipped.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-bulk-example">
                <strong><?php esc_html_e('Example:', 'screaming-fixes'); ?></strong>
                <div class="sf-table-wrapper">
                    <table class="sf-example-table">
                        <thead>
                            <tr>
                                <th>Source</th>
                                <th>Destination</th>
                                <th>Alt Text</th>
                                <th>New_Alt_Text</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>/about/</td>
                                <td>/images/team-photo.jpg</td>
                                <td></td>
                                <td><strong>Our team at the annual retreat</strong></td>
                            </tr>
                            <tr>
                                <td>/products/</td>
                                <td>/images/widget-pro.png</td>
                                <td></td>
                                <td><strong>Widget Pro product showcase</strong></td>
                            </tr>
                            <tr>
                                <td>/blog/</td>
                                <td>/images/hero.jpg</td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="sf-bulk-columns-info">
                <strong><?php esc_html_e('Accepted column names:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><code>New_Alt_Text</code>, <code>New_Alt</code>, <code>New_Image_Alt</code>, <code>New_Image_Alt_Text</code></li>
                </ul>
            </div>

            <div class="sf-bulk-safety-note">
                <span class="dashicons dashicons-shield"></span>
                <strong><?php esc_html_e('Safety:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('Rows without a New_Alt_Text value are always skipped. You can review all changes before applying.', 'screaming-fixes'); ?>
            </div>
        </div>
    </div>
</div>
