<?php
/**
 * Instructions partial for Internal Link Builder module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128218;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How to use the Internal Link Builder', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <h4 style="margin-top: 0;"><?php esc_html_e('Build Internal Links to a Page', 'screaming-fixes'); ?></h4>

            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Enter a priority URL', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Paste the URL of a page you want to build internal links to. This could be a cornerstone content page, product page, or any page you want to rank higher.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Select phrases to search for', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('The tool extracts phrases from the page title and H1. Select which phrases to scan your site for.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Review opportunities', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('The tool scans all posts and pages for mentions of your phrases. Review the suggested links showing the context where each phrase appears.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">4</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Add selected links', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Check the opportunities you want to convert to links and click "Add Selected Links". The tool will wrap the phrase in a link pointing to your priority URL.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <hr class="sf-instructions-divider" />

        <div class="sf-instructions-steps">
            <h4 style="margin-top: 0;"><?php esc_html_e('Bulk Upload Mode', 'screaming-fixes'); ?></h4>

            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Prepare your CSV file', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Create a CSV with three columns: Source_URL, Anchor_Text, and Target_URL. Each row defines one link to add.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Upload and review', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Drop your CSV file into the upload area. Review the confirmation screen showing which links will be added and any validation issues.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Apply changes', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Click "Confirm" to process all valid rows. The tool will find each anchor text in the source page and convert it to a link.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Required CSV columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><code>Source_URL</code> - <?php esc_html_e('The page where the link will be added', 'screaming-fixes'); ?></li>
                    <li><code>Anchor_Text</code> - <?php esc_html_e('The text to convert into a link', 'screaming-fixes'); ?></li>
                    <li><code>Target_URL</code> - <?php esc_html_e('Where the link should point to', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>

        <div class="sf-example-table">
            <strong><?php esc_html_e('Example CSV:', 'screaming-fixes'); ?></strong>
            <table class="sf-csv-example">
                <thead>
                    <tr>
                        <th>Source_URL</th>
                        <th>Anchor_Text</th>
                        <th>Target_URL</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>/blog/seo-tips/</td>
                        <td>keyword research</td>
                        <td>/services/keyword-research/</td>
                    </tr>
                    <tr>
                        <td>/blog/content-strategy/</td>
                        <td>internal linking</td>
                        <td>/guides/internal-linking-guide/</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <hr class="sf-instructions-divider" />

        <div class="sf-instructions-steps">
            <h4 style="margin-top: 0;"><?php esc_html_e('Fixing Orphan Pages', 'screaming-fixes'); ?></h4>
            <p style="margin-top: 0; color: #666;"><?php esc_html_e('Orphan pages have no internal links pointing to them. Use Screaming Frog to identify them, then add internal links in bulk.', 'screaming-fixes'); ?></p>

            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Export Orphan Pages from Screaming Frog', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Run a crawl, then go to Reports > Orphan Pages. Export as CSV. The file will have URL and Source columns.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Add required columns to the CSV', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Open the CSV and add two columns: Source_URL (page where link will be added) and Anchor_Text (text to convert to a link). The existing URL column becomes the link target.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Upload and apply', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Drop the modified CSV into the upload area. The tool will automatically detect the Orphan Pages format and map the columns correctly.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <div class="sf-example-table">
            <strong><?php esc_html_e('Orphan Pages CSV format:', 'screaming-fixes'); ?></strong>
            <table class="sf-csv-example">
                <thead>
                    <tr>
                        <th>URL</th>
                        <th>Source</th>
                        <th>Source_URL</th>
                        <th>Anchor_Text</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>/orphan-page/</td>
                        <td>GA</td>
                        <td>/blog/related-topic/</td>
                        <td>orphan page topic</td>
                    </tr>
                    <tr>
                        <td>/forgotten-article/</td>
                        <td>GSC</td>
                        <td>/resources/</td>
                        <td>forgotten article</td>
                    </tr>
                </tbody>
            </table>
            <p style="margin-top: 8px; font-size: 12px; color: #666;">
                <strong><?php esc_html_e('Column mapping:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('URL = Target (where link points), Source = ignored, Source_URL = where link is added, Anchor_Text = link text', 'screaming-fixes'); ?>
            </p>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tips:', 'screaming-fixes'); ?></strong>
                <ul style="margin: 5px 0 0 0; padding-left: 20px;">
                    <li><?php esc_html_e('Links are only added to the first occurrence of anchor text in each page.', 'screaming-fixes'); ?></li>
                    <li><?php esc_html_e('Text already inside a link will be skipped to avoid nested links.', 'screaming-fixes'); ?></li>
                    <li><?php esc_html_e('The search is case-insensitive but preserves original capitalization.', 'screaming-fixes'); ?></li>
                    <li><?php esc_html_e('Install Rank Math, Yoast, or AIOSEO to get additional phrase suggestions in discovery mode.', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
