<?php
/**
 * Instructions partial for Meta Description module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128218;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How to export Meta Descriptions from Screaming Frog', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Crawl your website', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Open Screaming Frog SEO Spider and enter your website URL. Click "Start" to begin the crawl.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Find Meta Description issues', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('After the crawl completes, click on the "Meta Description" tab in the second row of tabs (Internal | External | Security | Response Codes | URL | Page Titles | Meta Descriptions | H1 | H2 | Content | Images).', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Export the report', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Click the "Export" button to save as CSV or Google Sheet. You can export all issues or filter by specific issue types (Missing, Duplicate, Over X Characters, Below X Characters).', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">4</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Upload the CSV here', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Drag and drop the exported CSV file into the upload area above, or click to browse.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('The optimal meta description length is 120-155 characters. Descriptions longer than 155 characters may be truncated in search results.', 'screaming-fixes'); ?>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Expected CSV columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><code>Address</code> - <?php esc_html_e('The page URL', 'screaming-fixes'); ?></li>
                    <li><code>Meta Description 1</code> - <?php esc_html_e('Current meta description', 'screaming-fixes'); ?></li>
                    <li><code>Meta Description 1 Length</code> - <?php esc_html_e('Character count', 'screaming-fixes'); ?></li>
                    <li><code>Occurrences</code> - <?php esc_html_e('0=missing, 1=unique, >1=duplicate', 'screaming-fixes'); ?></li>
                    <li><code>Indexability</code> - <?php esc_html_e('Whether page is indexable', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>

        <hr class="sf-instructions-divider" />

        <div class="sf-instructions-alt">
            <strong><?php esc_html_e('Prefer working in spreadsheets?', 'screaming-fixes'); ?></strong>
            <p><?php esc_html_e('Add a New_Meta column to your Screaming Frog export to specify new meta descriptions directly in the spreadsheet. This lets you do all your work in Excel or Google Sheets before uploading.', 'screaming-fixes'); ?></p>
            <p><?php esc_html_e('Just drop the CSV into this tool and Screaming Fixes will automatically detect the format and apply your updates.', 'screaming-fixes'); ?></p>

            <div class="sf-example-table">
                <strong><?php esc_html_e('Example:', 'screaming-fixes'); ?></strong>
                <table class="sf-csv-example">
                    <thead>
                        <tr>
                            <th>Address</th>
                            <th>Meta Description 1</th>
                            <th>New_Meta</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>/about/</td>
                            <td>About us</td>
                            <td>Learn about our company's mission, values, and the team behind our success. Discover what makes us different.</td>
                        </tr>
                        <tr>
                            <td>/contact/</td>
                            <td>Contact</td>
                            <td>Get in touch with our team. We're here to help with questions, quotes, and support. Reach out today!</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <p class="sf-example-note"><?php esc_html_e('Rows without a New_Meta value will be skipped. You can also use New_Description or New_Meta_Description as column names.', 'screaming-fixes'); ?></p>
        </div>
    </div>
</div>
