<?php
/**
 * Instructions partial for Redirect Chains module
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="sf-instructions-box sf-collapsible" data-collapsed="true">
    <button type="button" class="sf-instructions-header" aria-expanded="false">
        <span class="sf-instructions-icon">&#128218;</span>
        <span class="sf-instructions-title"><?php esc_html_e('How to export Redirect Chains from Screaming Frog', 'screaming-fixes'); ?></span>
        <span class="sf-instructions-toggle">
            <span class="dashicons dashicons-arrow-down-alt2"></span>
        </span>
    </button>

    <div class="sf-instructions-content" style="display: none;">
        <div class="sf-instructions-steps">
            <div class="sf-step">
                <span class="sf-step-number">1</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Crawl your website', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Open Screaming Frog SEO Spider and enter your website URL. Click "Start" to begin the crawl.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">2</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Enable redirect chain detection', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Go to Configuration → Spider → Advanced and ensure "Always Follow Redirects" is checked.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">3</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Export All Redirects report', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('After the crawl completes, go to Reports → Redirects → All Redirects. Click "Export" to save the CSV file.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-step">
                <span class="sf-step-number">4</span>
                <div class="sf-step-content">
                    <strong><?php esc_html_e('Upload the CSV here', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Drag and drop the exported CSV file into the upload area above, or click to browse.', 'screaming-fixes'); ?></p>
                </div>
            </div>
        </div>

        <div class="sf-instructions-note">
            <span class="sf-note-icon">&#128161;</span>
            <div class="sf-note-content">
                <strong><?php esc_html_e('Tip:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('For best results, make sure to crawl all internal links and enable "Crawl All Subdomains" if your site uses subdomains.', 'screaming-fixes'); ?>
            </div>
        </div>

        <div class="sf-instructions-columns">
            <div class="sf-column-info">
                <strong><?php esc_html_e('Expected CSV columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li><code>Address</code> - <?php esc_html_e('The URL that redirects', 'screaming-fixes'); ?></li>
                    <li><code>Final Address</code> - <?php esc_html_e('The final destination URL', 'screaming-fixes'); ?></li>
                    <li><code>Number of Redirects</code> - <?php esc_html_e('How many hops in the chain', 'screaming-fixes'); ?></li>
                    <li><code>Source</code> - <?php esc_html_e('Page containing the link', 'screaming-fixes'); ?></li>
                    <li><code>Chain Type</code> - <?php esc_html_e('Type of redirect chain', 'screaming-fixes'); ?></li>
                    <li><code>Loop</code> - <?php esc_html_e('Indicates if this is a redirect loop (True/False)', 'screaming-fixes'); ?></li>
                    <li><code>Redirect Type 1</code> - <?php esc_html_e('HTTP status of first redirect (301, 302, etc.)', 'screaming-fixes'); ?></li>
                </ul>
            </div>
        </div>

        <!-- Bulk Fix Help -->
        <div class="sf-bulk-fix-help">
            <div class="sf-instructions-note">
                <span class="sf-note-icon">&#128221;</span>
                <div class="sf-note-content">
                    <strong><?php esc_html_e('Prefer working in spreadsheets?', 'screaming-fixes'); ?></strong>
                    <p><?php esc_html_e('Add an Action column to your Screaming Frog export to specify fixes directly. Rows without an Action value are automatically skipped.', 'screaming-fixes'); ?></p>
                </div>
            </div>

            <div class="sf-bulk-columns-info">
                <strong><?php esc_html_e('Optional bulk fix columns:', 'screaming-fixes'); ?></strong>
                <ul>
                    <li>
                        <code>Action</code> <span class="sf-column-required">(<?php esc_html_e('required for changes', 'screaming-fixes'); ?>)</span>
                        <ul class="sf-nested-list">
                            <li><code>fix</code> - <?php esc_html_e('Update content links (chains) or convert to 301 (temp redirects)', 'screaming-fixes'); ?></li>
                            <li><code>delete</code> - <?php esc_html_e('Remove redirect rule (loops or temp redirects)', 'screaming-fixes'); ?></li>
                            <li><code>skip</code> <?php esc_html_e('or blank', 'screaming-fixes'); ?> - <?php esc_html_e('Do nothing', 'screaming-fixes'); ?></li>
                        </ul>
                    </li>
                    <li>
                        <code>Override_Final</code> <span class="sf-column-optional">(<?php esc_html_e('optional, chains only', 'screaming-fixes'); ?>)</span>
                        <p class="sf-column-desc"><?php esc_html_e('Use this URL instead of Final Address when fixing content links.', 'screaming-fixes'); ?></p>
                    </li>
                    <li>
                        <code>Redirect_Code</code> <span class="sf-column-optional">(<?php esc_html_e('optional, temp redirects only', 'screaming-fixes'); ?>)</span>
                        <p class="sf-column-desc"><?php esc_html_e('Defaults to 301. Use 302 or 307 if needed.', 'screaming-fixes'); ?></p>
                    </li>
                </ul>
            </div>

            <div class="sf-bulk-example">
                <strong><?php esc_html_e('Example:', 'screaming-fixes'); ?></strong>
                <div class="sf-table-wrapper">
                    <table class="sf-example-table">
                        <thead>
                            <tr>
                                <th>Address</th>
                                <th>Final Address</th>
                                <th>Action</th>
                                <th>Override_Final</th>
                                <th>Redirect_Code</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>/old-page</td>
                                <td>/new-page</td>
                                <td><strong>fix</strong></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>/outdated</td>
                                <td>/wrong</td>
                                <td><strong>fix</strong></td>
                                <td>/correct</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>/loop-a</td>
                                <td>/loop-b</td>
                                <td><strong>delete</strong></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>/temp-promo</td>
                                <td>/landing</td>
                                <td><strong>fix</strong></td>
                                <td></td>
                                <td>301</td>
                            </tr>
                            <tr>
                                <td>/keep-302</td>
                                <td>/ab-test</td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="sf-bulk-safety-note">
                <span class="dashicons dashicons-shield"></span>
                <strong><?php esc_html_e('Safety:', 'screaming-fixes'); ?></strong>
                <?php esc_html_e('Rows without an Action value are always skipped. You can review all changes before applying.', 'screaming-fixes'); ?>
            </div>
        </div>
    </div>
</div>
