<?php
/**
 * Plugin Name: Screaming Fixes
 * Plugin URI: https://screamingfixes.com
 * Description: Finding SEO problems is easy. Fixing them sucks. This plugin actually fixes them—in bulk.
 * Version: 1.0.0
 * Author: Brett Lindenberg
 * Author URI: https://screamingfixes.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: screaming-fixes
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('SF_VERSION', '1.0.0');
define('SF_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SF_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SF_PLUGIN_FILE', __FILE__);
define('SF_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Load MailerLite subscription endpoint
require_once plugin_dir_path(__FILE__) . 'includes/sf-mailerlite-endpoint.php';

/**
 * Initialize the plugin
 */
function sf_init() {
    // Load core plugin class
    require_once SF_PLUGIN_DIR . 'includes/class-plugin.php';

    // Initialize the plugin
    SF_Plugin::get_instance();

    // Check for database upgrades
    SF_Database::maybe_upgrade();
}
add_action('plugins_loaded', 'sf_init');

/**
 * Activation hook
 */
function sf_activate() {
    // Load and run plugin activation
    require_once SF_PLUGIN_DIR . 'includes/class-plugin.php';
    SF_Plugin::activate();
}
register_activation_hook(__FILE__, 'sf_activate');

/**
 * Deactivation hook
 */
function sf_deactivate() {
    // Load and run plugin deactivation
    require_once SF_PLUGIN_DIR . 'includes/class-plugin.php';
    SF_Plugin::deactivate();
}
register_deactivation_hook(__FILE__, 'sf_deactivate');

/**
 * Helper function to get plugin instance
 *
 * @return SF_Plugin
 */
function screaming_fixes() {
    return SF_Plugin::get_instance();
}
