<?php
/**
 * Screaming Fixes Uninstall
 *
 * Cleanup all plugin data when uninstalled
 */

// Exit if not called by WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Only clean up if user explicitly wants to remove all data
$remove_data = get_option('sf_remove_data_on_uninstall', false);

if (!$remove_data) {
    // Keep data by default - user can enable this in settings
    return;
}

global $wpdb;

// Drop custom tables
$tables = [
    $wpdb->prefix . 'screaming_fixes_log',
    $wpdb->prefix . 'screaming_fixes_backlink_cache',
    $wpdb->prefix . 'screaming_fixes_uploads',
    // Legacy tables from earlier versions
    $wpdb->prefix . 'sf_broken_links',
    $wpdb->prefix . 'sf_redirect_chains',
    $wpdb->prefix . 'sf_backlinks',
    $wpdb->prefix . 'sf_images',
];

foreach ($tables as $table) {
    $wpdb->query("DROP TABLE IF EXISTS {$table}");
}

// Delete all plugin options
$options = [
    'sf_version',
    'sf_enable_logging',
    'sf_debug_mode',
    'sf_claude_api_key',
    'sf_preferred_redirect_plugin',
    'sf_email_subscribed',
    'sf_last_backlink_scan',
    'sf_remove_data_on_uninstall',
    // Module enable/disable options
    'sf_enable_broken-links',
    'sf_enable_redirect-chains',
    'sf_enable_backlink-reclaim',
    'sf_enable_image-alt-text',
];

foreach ($options as $option) {
    delete_option($option);
}

// Delete all transients
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_sf_%' OR option_name LIKE '_transient_timeout_sf_%'"
);

// Clean up upload directory
$upload_dir = wp_upload_dir();
$temp_dir = $upload_dir['basedir'] . '/screaming-fixes-temp/';

if (is_dir($temp_dir)) {
    $files = glob($temp_dir . '*');
    if ($files) {
        foreach ($files as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
    }
    rmdir($temp_dir);
}

// Clear any cached data
wp_cache_flush();
